package coreservlets;

import javax.servlet.http.*;
import org.apache.struts.action.*;

/** Klasa Action, ktra rcznie sprawdza poprawno waciwoci
 *  komponentu bean. Jeeli w danych podanych przez uytkownika
 *  wystpuje jaki problem, klasa Action tworzy komunikaty
 *  ostrzegawcze i umieszcza je w zasigu dania.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class ShowSampleAction extends Action {
  public ActionForward execute(ActionMapping mapping,
                               ActionForm form,
                               HttpServletRequest request,
                               HttpServletResponse response)
      throws Exception {
    FormatFormBean formatBean = (FormatFormBean)form;
    ActionForward forward = mapping.findForward("success");
    ActionMessages messages = new ActionMessages();

    if (formatBean.isMissing(formatBean.getTitleSize())) {
      addMessage(messages, "title", "Brak rozmiaru tytuu");
      forward = mapping.findForward("missing-data");
    }
    if (formatBean.isMissing(formatBean.getHeadingSize())) {
      addMessage(messages, "headings", "Brak rozmiaru nagwka");
      forward = mapping.findForward("missing-data");
    }
    if (formatBean.isMissing(formatBean.getBodySize())) {
      addMessage(messages, "body", "Brak rozmiaru tekstu");
      forward = mapping.findForward("missing-data");
    }
    if (formatBean.isMissing(formatBean.getBgColor())) {
      addMessage(messages, "bg", "Brak koloru ta");
      forward = mapping.findForward("missing-data");
    }
    if (formatBean.isMissing(formatBean.getFgColor())) {
      addMessage(messages, "fg", "Brak koloru pierwszoplanowego");
      forward = mapping.findForward("missing-data");
    } else if (formatBean.getFgColor().equals
                 (formatBean.getBgColor())) {
      addMessage(messages, "fg",
                 "Kolor pierwszoplanowy i kolor ta s identyczne!");
      forward = mapping.findForward("missing-data");
    }
    if (!messages.isEmpty()) {
      addMessages(request, messages);
    }
    return(forward);
  }

  protected void addMessage(ActionMessages messages,
                            String property,
                            String warning) {
     messages.add(property, new ActionMessage(warning, false));
  }
}
